unit ZPL_Delphi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, PrinterLib,
  Controls, Forms,  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

function UnicodeToAnsi(Str: String): AnsiString;
var
  Len: integer;
begin
  Len := Length(Str) * 2 + 1; // one for #0
  SetLength(Result, Len);
  Len := WideCharToMultiByte(CP_ACP, 0, PWideChar(Str), -1, PAnsiChar(Result),
    Len, nil, nil);
  SetLength(Result, Len);
end;

function AnsiToUnicode(Str: AnsiString): String;
var
  Len: integer;
begin
  Len := Length(Str) + 1;
  SetLength(Result, Len);
  Len := MultiByteToWideChar(CP_ACP, 0, PAnsiChar(Str), -1, PWideChar(Result),
    Len);
  SetLength(Result, Len); // end is #0
end;
{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  iResult: integer;
  preadedNum: integer;
 // strrfid: array[0..8] of char;
  strrfid:PByte;
begin
  GetMem(strrfid, 10);
  iResult := DemoPrinterCreator('HD100');

  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      //ôӡŨ
      iResult := DemoSetPrintDarkness(20);

      //Ƿе
      iResult := DemoSetPrintMode('T','N');
      iResult := DemoSetPrintQuantity(1,0,1,'N');

      //Ƿתӡ
      iResult := DemoSetPrintOrientation(180);

      //ӡͼƬ
      iResult := DemoPrintImage(100, 100, 'D:\\1.bmp');

      //ӡPdf417
      iResult := DemoPdf417(100, 250, 0, 2, 20, 2, 5, 5, 'N', '0010101101');

      //ӡBarCode39
      iResult := DemoBarCode39(100, 400, 0, 3, 50, 'Y', 'Y', 'Y', '66886868');

      //ӡCodeEan8
      iResult := DemoCodeEan8(100, 500, 0, 3, 60, 'Y', 'Y', '90381010');

      //ӡUPC-A
      iResult := DemoUpcaBarcode(100, 600, 0, 3, 50, 'Y', 'Y', 'N', '47631664454');

      //ӡUPCչ
      iResult := DemoUpcExtensions(100, 700, 0, 3, 50, 'Y', 'Y', '01234');

      //ӡά
      iResult := DemoQRCode(100, 800, 0, 1, 3, 'M', 'M','N', '1000000001');

      //ӡ
      iResult := DemoSetChangeFontEncoding(14);
      iResult := DemoText(100, 900, 16, 0, 40, 40, '');
      iResult := DemoText(300, 900, 16, 0, 40, 40, 'hello');
      iResult := DemoText(500, 900, 16, 0, 40, 40, 'ˤ');

      //ӡͼԲȦ
      iResult := DemoGraphicCircle(100, 1000, 150, 5);

      //ӡͼԲ
      iResult := DemoGraphicEllipse(300, 1000, 150, 100, 10);

      //ӡԽ
      iResult := DemoGraphicDiagonalLine(500, 1000, $52, 50, 50, 20);

      //ӡͼο
      iResult := DemoGraphicBox(100, 1200, 100, 100, 60, 3);

      //ӡ
      iResult := DemoGraphicSymbol(300, 1200, 0, 200, 200, 'A');

      //RFIDд
      iResult := DemoRfidWrite('H', 2, 4, 1, '12345678');
      iResult := DemoRfidRead('H', 2, 4, 1, 'a','z');
      //
      iResult := DemoEndFormat();

      iResult := DemoReadData(strrfid,10,preadedNum);

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;

end;

end.
